#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Ojascki - CallingMod01.fsh   by  BigWIngs    
//https://www.shadertoy.com/view/3sG3zy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Remake of "Calling" by Ojascki coded by Martijn Steinrucken aka BigWings - 2019
// countfrolic@gmail.com
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// 
// A quick and dirty remake of an effect by Ojascki
// https://www.facebook.com/ojasckI/photos/a.237033287121146/511096019714870/?type=3&theater


// Fabrice cleaned up my dirty code. Much nicer!
#define O fragColor
#define u fragCoord

//void mainImage( out vec4 O, vec2 u )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 R = iResolution.xy,
         U = ( u - .5*R ) / R.x;
	
    float a = iTime; a += sin(a*.5)*.25;
    U *= mat2(cos(a), -sin(a), sin(a), cos(a));

    a = 2. + sin(a*.4); 
    float x = atan(U.x, U.y)/6.283+.5,  
          y = 20./(9.*length(U)*a*a) - x;   
    x += ceil(y);
    y = fract(y)-.5;
    x = ( x*x*4.- sqrt(.25-y*y) )*3.;
    float w = fwidth(x),
          c = smoothstep(w, -w, abs(fract(x)-.5)-.25);
     
    fragColor = vec4( (c-.5) *  max(0.,1.-w) +.5 );


// Original 'dirty' version
/* 
void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.x;
	
    float a = iTime;
    a += sin(a*.5)*.25;
    uv *= mat2(cos(a), -sin(a), sin(a), cos(a));
    uv /= pow(length(uv*(6.+sin(a*.4)*3.)), 2.);
    
    vec3 col = vec3(0);
    
    float x = atan(uv.x, uv.y)/6.283+.5, x1=x, y = length(uv)*20.;
    
    x = x+floor(y-x)+1.;
    
    y = fract(y-x1)-.5;
    x = (x*x*4.-sqrt(.25-y*y))*3.;
    float w = fwidth(x);
    col += smoothstep(w, -w, abs(fract(x)-.5)-.25);
    
    col = (col-.5)*smoothstep(1., .0, w)+.5;
    

    fragColor = vec4(col,1.0);
}*/

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

